<?php
/** @var $clients array */
/** @var $auctions array */
/** @var $warehouses array */
/** @var $destinations array */
?>

<div class="modal fade" id="carModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg rounded-4">
            <div class="modal-header border-0 bg-light rounded-top-4 px-4">
                <h5 class="fw-bold mb-0">
                    <i class="bi bi-car-front-fill me-2 text-primary"></i>
                    {{ isEditing ? 'Update Vehicle: ' + (formData.vin || '') : 'Register New Vehicle' }}
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            
            <div class="modal-body p-0">
                <ul class="nav nav-tabs nav-fill bg-light px-3" id="carTab" role="tablist">
                    <li class="nav-item">
                        <button class="nav-link active fw-bold py-3" data-bs-toggle="tab" data-bs-target="#basic-info">
                            <i class="bi bi-card-checklist me-1"></i> 1. Vehicle & Logistics
                        </button>
                    </li>
                    <li class="nav-item" v-for="stage in [{id:'auction', label:'Auction', icon:'bi-hammer'}, {id:'warehouse', label:'Warehouse', icon:'bi-house'}, {id:'loading', label:'Loading', icon:'bi-truck'}]">
                        <button class="nav-link fw-bold py-3" data-bs-toggle="tab" :data-bs-target="'#' + stage.id + '-tab'">
                            <i :class="stage.icon + ' me-1'"></i> {{ stage.label }} Photos
                        </button>
                    </li>
                </ul>

                <form @submit.prevent="saveCar" class="p-4" enctype="multipart/form-data">
                    <div class="tab-content" id="carTabContent">
                        
                        <div class="tab-pane fade show active" id="basic-info">
                            <div class="row g-3">
                                
                                <div class="col-md-3">
                                    <label class="small fw-bold text-muted">SHIPPING LINE</label>
                                    <input type="text" v-model="formData.shipping_line" class="form-control shadow-sm">
                                </div>
                                <div class="col-md-2">
                                    <label class="small fw-bold text-muted">YEAR</label>
                                    <input type="text" v-model="formData.year" class="form-control shadow-sm">
                                </div>
                                <div class="col-md-4">
                                    <label class="small fw-bold text-muted">VIN</label>
                                    <input type="text" v-model="formData.vin" class="form-control shadow-sm">
                                </div>
                                <div class="col-md-3">
                                    <label class="small fw-bold text-muted">LINER</label>
                                    <select v-model="formData.liner" class="form-select shadow-sm">
                                        <option value="">Select Liner...</option>
                                        <option v-for="l in ['CMA CGM', 'ONE-LINE', 'EVERGREEN', 'MAERSK', 'COSCO', 'HYUNDAI', 'ZIM', 'OOCL', 'MSC']" :value="l">{{l}}</option>
                                    </select>
                                </div>

                                <div class="col-md-8">
                                    <label class="small fw-bold text-muted">VEHICLE INFO</label>
                                    <input type="text" v-model="formData.info" class="form-control shadow-sm" placeholder="Color, Engine, Specs...">
                                </div>
                                <div class="col-md-4">
                                    <label class="small fw-bold text-muted">TITLE/KEY</label>
                                    <input type="text" v-model="formData.title" class="form-control shadow-sm">
                                </div>

                                <div class="col-md-3">
                                    <label class="small fw-bold text-muted">PURCHASE DATE</label>
                                    <input type="date" v-model="formData.purchase_date" class="form-control shadow-sm">
                                </div>
                                <div class="col-md-3">
                                    <label class="small fw-bold text-muted">RECEIVED DATE</label>
                                    <input type="date" v-model="formData.received_date" class="form-control shadow-sm">
                                </div>
                                <div class="col-md-3">
                                    <label class="small fw-bold text-muted">ETA</label>
                                    <input type="date" v-model="formData.eta_date" class="form-control shadow-sm">
                                </div>
                                <div class="col-md-3">
                                    <label class="small fw-bold text-muted">AUCTION TYPE</label>
                                    <select v-model="formData.auction_id" class="form-select shadow-sm">
                                        <option value="">Select Auction...</option>
                                        <?php foreach ($auctions as $a): ?>
                                            <option value="<?= $a['id'] ?>"><?= htmlspecialchars($a['name']) ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>

                                <div class="col-md-3">
                                    <label class="small fw-bold text-muted">CONTAINER NO</label>
                                    <input type="text" v-model="formData.container" class="form-control shadow-sm">
                                </div>
                                <div class="col-md-3">
                                    <label class="small fw-bold text-muted">LOT</label>
                                    <input type="text" v-model="formData.lot" class="form-control shadow-sm" required>
                                </div>
                                <div class="col-md-3">
                                    <label class="small fw-bold text-muted">DESTINATION</label>
                                    <select v-model="formData.destination_id" class="form-select shadow-sm">
                                        <option value="">Select Destination...</option>
                                        <?php foreach ($destinations as $d): ?>
                                            <option value="<?= $d['id'] ?>"><?= htmlspecialchars($d['name']) ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label class="small fw-bold text-muted">WAREHOUSE PORT</label>
                                    <select v-model="formData.warehouse_id" class="form-select shadow-sm">
                                        <option value="">Select Warehouse...</option>
                                        <?php foreach ($warehouses as $w): ?>
                                            <option value="<?= $w['id'] ?>"><?= htmlspecialchars($w['name']) ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="small fw-bold text-muted">CLIENT INFO</label>
                                    <select v-model="formData.client_id" class="form-select shadow-sm" required @change="updateClientContact">
                                        <option value="">Select Client...</option>
                                        <?php foreach ($clients as $client): ?>
                                            <option value="<?= $client['id'] ?>">
                                                <?= htmlspecialchars($client['no'] . ' - ' . $client['name']) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                    <div v-if="formData.client_id" class="mt-1 small text-primary fw-bold">
                                        <i class="bi bi-telephone me-1"></i> Contact: {{ getClientPhone(formData.client_id) }}
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <label class="small fw-bold text-muted">PRICE</label>
                                    <div class="input-group shadow-sm">
                                        <span class="input-group-text">$</span>
                                        <input type="number" step="0.01" v-model="formData.price" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <label class="small fw-bold text-muted">STATUS</label>
                                    <select v-model="formData.status" class="form-select shadow-sm">
                                        <option value="at_auction">At Auction</option>
                                        <option value="at_yard">At Yard</option>
                                        <option value="arrived">Arrived</option>
                                        <option value="paid">Paid</option>
                                        <option value="unpaid">Unpaid</option>
                                    </select>
                                </div>

                                <div class="col-md-12">
                                    <label class="small fw-bold text-danger">INTERNAL NOTE (RED TEXT)</label>
                                    <textarea v-model="formData.note" class="form-control shadow-sm text-danger fw-bold" rows="2"></textarea>
                                </div>
                            </div>
                        </div>

                        <div v-for="type in ['auction', 'warehouse', 'loading']" :key="type" class="tab-pane fade" :id="type + '-tab'">
                             <div class="upload-container text-center border border-2 border-dashed rounded-4 p-5 bg-light mb-4" 
                                  @dragover.prevent @drop.prevent="handleDrop($event, type)"
                                  @click="$refs[type + 'Input'][0].click()">
                                <i class="bi bi-cloud-arrow-up fs-1 text-primary"></i>
                                <h5 class="mt-3">Click or Drag & Drop Multiple {{ type }} Photos</h5>
                                <input type="file" :ref="type + 'Input'" class="d-none" multiple accept="image/*" @change="handleFileSelect($event, type)">
                            </div>

                            <div class="row g-3 overflow-auto" style="max-height: 400px;">
                                <div v-for="img in existingImages.filter(i => i.type === type)" :key="img.id" class="col-md-2 position-relative">
                                    <div class="card h-100 shadow-sm border-0">
                                        <img :src="'<?= Yii::$app->request->baseUrl ?>/' + img.image_path" class="card-img-top rounded object-fit-cover" height="120">
                                        <button type="button" @click="deleteExistingImage(img.id)" class="btn btn-danger btn-sm position-absolute top-0 end-0 m-1 rounded-circle">
                                            <i class="bi bi-x"></i>
                                        </button>
                                    </div>
                                </div>

                                <div v-for="(preview, index) in newPreviews[type]" :key="'new-' + index" class="col-md-2 position-relative">
                                    <div class="card h-100 shadow-sm border-0 bg-primary-subtle">
                                        <img :src="preview" class="card-img-top rounded object-fit-cover" height="120">
                                        <div class="position-absolute top-0 start-0 m-1 badge bg-primary">New</div>
                                        <button type="button" @click="removeNewImage(type, index)" class="btn btn-dark btn-sm position-absolute top-0 end-0 m-1 rounded-circle">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end gap-2 mt-4 pt-3 border-top">
                        <button type="button" class="btn btn-light rounded-pill px-4 fw-bold" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary rounded-pill px-4 shadow-sm fw-bold" :disabled="loading">
                            <span v-if="loading" class="spinner-border spinner-border-sm me-1"></span>
                            <i v-else class="bi bi-check-lg me-1"></i>
                            {{ isEditing ? 'Update Vehicle' : 'Create Vehicle' }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
.border-dashed { border-style: dashed !important; border-width: 2px !important; border-color: #dee2e6 !important; transition: 0.3s; cursor: pointer; }
.border-dashed:hover { border-color: #0d6efd !important; background-color: #f0f7ff !important; }
.object-fit-cover { object-fit: cover; }
.nav-tabs .nav-link { color: #6c757d; border: none; border-bottom: 3px solid transparent; }
.nav-tabs .nav-link.active { background: transparent !important; border: none !important; border-bottom: 3px solid #0d6efd !important; color: #0d6efd !important; }
</style>